/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import panther.util.general.ErrorUtils;
import pse.util.general.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    protected static final int BUFFER_SIZE = 65536;

    public static String toString(InputStream inputStream) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return FileUtils.readFile(inputStreamReader).toString();
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws Exception {
        IOUtils.copy(inputStream, outputStream, true);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, boolean bl) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        int n = 0;
        byte[] byArray = new byte[4096];
        while ((n = bufferedInputStream.read(byArray, 0, 4096)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.flush();
        if (bl) {
            bufferedInputStream.close();
            bufferedOutputStream.close();
        }
    }

    public static void copy(Reader reader, Writer writer) throws Exception {
        IOUtils.copy(reader, writer, true);
    }

    public static void copy(Reader reader, Writer writer, boolean bl) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(reader);
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        int n = 0;
        char[] cArray = new char[4096];
        while ((n = bufferedReader.read(cArray, 0, 4096)) != -1) {
            bufferedWriter.write(cArray, 0, n);
        }
        bufferedWriter.flush();
        if (bl) {
            bufferedReader.close();
            bufferedWriter.close();
        }
    }

    public static void copy(InputStream inputStream, Writer writer) throws Exception {
        IOUtils.copy(new InputStreamReader(inputStream), writer);
    }

    public static void copy(InputStream inputStream, Writer writer, boolean bl) throws Exception {
        IOUtils.copy(new InputStreamReader(inputStream), writer, bl);
    }

    public static String read(Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray, 0, 4096)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        reader.close();
        return stringBuilder.toString();
    }

    public static byte[] readBytes(InputStream inputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static String readUploadedFile(InputStream inputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8164);
        int n = 0;
        byte[] byArray = new byte[4096];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray, 0, 4096)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
            n += n2;
        }
        String string = byteArrayOutputStream.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        boolean bl = true;
        while (bl) {
            if (stringTokenizer.nextToken().indexOf("Content-Type") == -1) continue;
            bl = false;
            stringTokenizer.nextToken();
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        while (!bl2) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("--------------------")) {
                bl2 = true;
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString().trim();
    }

    public static List<String> readUploadedMime(InputStream inputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
        int n = 0;
        byte[] byArray = new byte[4096];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray, 0, 4096)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
            n += n2;
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        int n4 = IOUtils.indexOf("Content-Type", byArray2);
        while (n4 >= 0) {
            int n5 = IOUtils.indexOf("\n", byArray2, n4);
            if (n5 >= 0) {
                arrayList.add(new String(byArray2, n3, n5 - n3));
                n3 = n5;
                n4 = IOUtils.indexOf("Content-Type", byArray2, n5 + 1);
                if (n4 < 0) continue;
                arrayList.add(new String(byArray2, n5, n4 - n5));
                n3 = n4;
                continue;
            }
            n4 = -1;
        }
        if (n3 >= 0 && n3 < byArray2.length) {
            arrayList.add(new String(byArray2, n3, byArray2.length - n3));
        }
        return arrayList;
    }

    public static String[] readUploadedMime2(InputStream inputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
        int n = 0;
        byte[] byArray = new byte[4096];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray, 0, 4096)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
            n += n2;
        }
        String string = byteArrayOutputStream.toString();
        return string.split("\n");
    }

    public static byte[] readUploadedBinaryFile(InputStream inputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
        IOUtils.readUploadedBinaryFile(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void readUploadedBinaryFile(InputStream inputStream, File file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        IOUtils.readUploadedBinaryFile(inputStream, fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public static void readUploadedBinaryFile(InputStream inputStream, OutputStream outputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
        int n = 0;
        byte[] byArray = new byte[4096];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray, 0, 4096)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
            n += n2;
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        int n3 = IOUtils.indexOf("Content-Type", byArray2);
        int n4 = IOUtils.indexOf("\n", byArray2, n3);
        int n5 = IOUtils.indexOf("--------------------", byArray2, n4 += 3);
        outputStream.write(byArray2, n4, (n5 -= 2) - n4);
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                ErrorUtils.check(throwable);
            }
        }
    }

    public static void write(Writer writer, String string) throws Exception {
        IOUtils.copy(new StringReader(string), writer);
    }

    public static boolean streamsDiffer(InputStream inputStream, InputStream inputStream2) throws Exception {
        byte[] byArray = new byte[65536];
        byte[] byArray2 = new byte[65536];
        boolean bl = false;
        while (!bl) {
            int n;
            int n2 = inputStream.read(byArray, 0, 65536);
            if (n2 != (n = inputStream2.read(byArray2, 0, 65536))) {
                return true;
            }
            if (!Arrays.equals(byArray, byArray2)) {
                return true;
            }
            bl = n2 < 65536 | n < 65536;
        }
        return false;
    }

    public static int indexOf(String string, byte[] byArray) {
        return IOUtils.indexOf(string, byArray, 0);
    }

    public static int indexOf(String string, byte[] byArray, int n) {
        byte[] byArray2 = string.getBytes();
        for (int i = n; i < byArray.length; ++i) {
            if (!IOUtils.matches(byArray2, byArray, i)) continue;
            return i;
        }
        return -1;
    }

    public static boolean matches(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < byArray.length; ++i) {
            if (n + i >= byArray2.length) {
                return false;
            }
            if (byArray[i] == byArray2[n + i]) continue;
            return false;
        }
        return true;
    }
}

